/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.io.InputStream;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.function.LuaClosure;
import org.squiddev.cobalt.function.LuaInterpretedFunction;

public final class LoadState {
    private static final int NAME_LENGTH = 30;
    private static final int FILE_LENGTH = 30 - " '...' ".length() - 1;
    private static final int STRING_LENGTH = 30 - " [string \"...\"] ".length() - 1;
    private static final LuaString REMAINING = ValueFactory.valueOf("...");
    private static final LuaString STRING = ValueFactory.valueOf("[string \"");
    private static final LuaString EMPTY_STRING = ValueFactory.valueOf("[string \"\"]");
    private static final LuaString NEW_LINES = ValueFactory.valueOf("\r\n");

    private LoadState() {
    }

    public static LuaClosure interpretedFunction(Prototype prototype, LuaValue env) {
        LuaInterpretedFunction closure = new LuaInterpretedFunction(prototype);
        closure.nilUpvalues();
        if (closure.upvalues.length > 0) {
            closure.upvalues[0].setValue(env);
        }
        return closure;
    }

    public static LuaClosure load(LuaState state, InputStream stream, String name, LuaValue env) throws CompileException, LuaError {
        return LoadState.load(state, stream, ValueFactory.valueOf(name), env);
    }

    public static LuaClosure load(LuaState state, InputStream stream, LuaString name, LuaValue env) throws CompileException, LuaError {
        return state.compiler.load(LuaC.compile(state, stream, name), env);
    }

    static LuaString getShortName(LuaString name) {
        if (name.length() == 0) {
            return EMPTY_STRING;
        }
        switch (name.charAt(0)) {
            case 61: {
                return name.substringOfEnd(1, Math.min(30, name.length()));
            }
            case 64: {
                if (name.length() - 1 > FILE_LENGTH) {
                    byte[] bytes = new byte[FILE_LENGTH + 3];
                    REMAINING.copyTo(bytes, 0);
                    name.copyTo(name.length() - FILE_LENGTH, bytes, REMAINING.length(), FILE_LENGTH);
                    return ValueFactory.valueOf(bytes);
                }
                return name.substring(1);
            }
        }
        int len = name.indexOfAny(NEW_LINES);
        boolean truncate = false;
        if (len < 0) {
            len = name.length();
        } else {
            truncate = true;
        }
        if (len > STRING_LENGTH) {
            truncate = true;
            len = STRING_LENGTH;
        }
        byte[] out = new byte[30];
        STRING.copyTo(out, 0);
        int offset = STRING.length();
        offset = name.copyTo(0, out, offset, len);
        if (truncate) {
            offset = REMAINING.copyTo(out, offset);
        }
        out[offset++] = 34;
        out[offset++] = 93;
        return LuaString.valueOf(out, 0, offset);
    }

    static void checkMode(LuaString mode, String current) throws CompileException {
        if (mode != null && mode.indexOf((byte)current.charAt(0)) == -1) {
            throw new CompileException("attempt to load a " + current + " chunk (mode is " + String.valueOf(mode) + ")");
        }
    }

    public static interface FunctionFactory {
        public LuaClosure load(Prototype var1, LuaValue var2);
    }
}

